<?php

/*
 * This file is part of the API Platform project.
 *
 * (c) Kévin Dunglas <dunglas@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace ApiPlatform\SchemaGenerator\Tests\Command;

use ApiPlatform\SchemaGenerator\Command\ExtractCardinalitiesCommand;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Console\Tester\CommandTester;

/**
 * @author Kévin Dunglas <dunglas@gmail.com>
 */
class ExtractCardinalitiesCommandTest extends TestCase
{
    public function testExtractCardinalities(): void
    {
        $commandTester = new CommandTester(new ExtractCardinalitiesCommand());
        $this->assertEquals(0, $commandTester->execute(
            ['--schemaorg-file' => __DIR__.'/../../data/schema.rdfa', '--goodrelations-file' => __DIR__.'/../../data/v1.owl']
        ));

        $this->assertEquals(<<<'JSON'
{
    "geoRadius": "unknown",
    "geoMidpoint": "unknown",
    "hasOfferCatalog": "unknown",
    "mapType": "unknown",
    "touristType": "(0..*)",
    "orderQuantity": "(0..1)",
    "orderItemStatus": "(0..1)",
    "orderItemNumber": "(0..1)",
    "orderDelivery": "(0..1)",
    "additionalNumberOfGuests": "unknown",
    "rsvpResponse": "(0..1)",
    "schemaVersion": "unknown",
    "about": "(0..1)",
    "acceptedOffer": "(0..*)",
    "acceptedPaymentMethod": "(0..*)",
    "acceptsReservations": "unknown",
    "accessCode": "unknown",
    "accessibilityAPI": "unknown",
    "accessibilityControl": "unknown",
    "accessibilityFeature": "unknown",
    "accessibilityHazard": "unknown",
    "accountablePerson": "unknown",
    "acquiredFrom": "(0..1)",
    "actor": "unknown",
    "actors": "unknown",
    "additionalName": "unknown",
    "additionalType": "unknown",
    "addOn": "(0..*)",
    "address": "unknown",
    "addressCountry": "(0..1)",
    "addressLocality": "(0..1)",
    "addressRegion": "(0..1)",
    "advanceBookingRequirement": "(0..1)",
    "affiliation": "unknown",
    "agent": "(0..1)",
    "aggregateRating": "(0..1)",
    "album": "unknown",
    "albums": "unknown",
    "alignmentType": "unknown",
    "alternateName": "unknown",
    "alternativeHeadline": "unknown",
    "alumni": "unknown",
    "alumniOf": "unknown",
    "amountOfThisGood": "(1..1)",
    "applicationCategory": "unknown",
    "applicationSubCategory": "unknown",
    "applicationSuite": "(0..1)",
    "appliesToDeliveryMethod": "(0..*)",
    "appliesToPaymentMethod": "(1..*)",
    "area": "(0..1)",
    "areaServed": "(0..1)",
    "articleBody": "(0..1)",
    "articleSection": "(0..*)",
    "assembly": "unknown",
    "executableLibraryName": "unknown",
    "assemblyVersion": "unknown",
    "associatedArticle": "unknown",
    "associatedMedia": "unknown",
    "organizer": "unknown",
    "attendee": "unknown",
    "attendees": "unknown",
    "audience": "unknown",
    "audienceType": "(0..1)",
    "audio": "unknown",
    "author": "(0..1)",
    "availability": "(0..1)",
    "availabilityEnds": "(0..1)",
    "availabilityStarts": "(0..1)",
    "availableAtOrFrom": "(0..*)",
    "availableChannel": "unknown",
    "availableDeliveryMethod": "(0..*)",
    "availableFrom": "unknown",
    "availableLanguage": "unknown",
    "availableThrough": "unknown",
    "award": "unknown",
    "awards": "unknown",
    "baseSalary": "(0..1)",
    "bccRecipient": "unknown",
    "benefits": "unknown",
    "jobBenefits": "unknown",
    "bestRating": "(0..1)",
    "billingAddress": "(0..1)",
    "billingIncrement": "(0..1)",
    "birthDate": "unknown",
    "bitrate": "(0..1)",
    "blogPost": "unknown",
    "blogPosts": "(0..1)",
    "bookEdition": "(0..1)",
    "bookFormat": "(0..1)",
    "borrower": "unknown",
    "box": "unknown",
    "branchOf": "(0..1)",
    "parentOrganization": "(0..1)",
    "branchCode": "unknown",
    "brand": "(0..*)",
    "breadcrumb": "unknown",
    "broadcaster": "(0..1)",
    "browserRequirements": "unknown",
    "businessFunction": "(1..*)",
    "buyer": "unknown",
    "byArtist": "(0..1)",
    "candidate": "unknown",
    "caption": "(0..1)",
    "carrier": "unknown",
    "carrierRequirements": "(0..*)",
    "catalog": "unknown",
    "includedDataCatalog": "unknown",
    "includedInDataCatalog": "unknown",
    "category": "(0..*)",
    "ccRecipient": "unknown",
    "childMaxAge": "unknown",
    "childMinAge": "unknown",
    "children": "unknown",
    "circle": "unknown",
    "citation": "unknown",
    "clipNumber": "unknown",
    "closes": "(1..1)",
    "codeRepository": "unknown",
    "colleague": "unknown",
    "colleagues": "unknown",
    "collection": "unknown",
    "targetCollection": "unknown",
    "color": "(0..1)",
    "comment": "unknown",
    "commentText": "(0..1)",
    "commentTime": "(0..1)",
    "confirmationNumber": "unknown",
    "contactOption": "unknown",
    "contactPoint": "unknown",
    "contactPoints": "unknown",
    "contactType": "unknown",
    "containedInPlace": "(0..1)",
    "containsPlace": "(0..1)",
    "containedIn": "(0..1)",
    "contentLocation": "(0..1)",
    "locationCreated": "(0..1)",
    "contentRating": "unknown",
    "contentSize": "unknown",
    "contentUrl": "unknown",
    "expectsAcceptanceOf": "unknown",
    "contributor": "unknown",
    "copyrightHolder": "(0..1)",
    "copyrightYear": "(0..1)",
    "countriesNotSupported": "unknown",
    "countriesSupported": "unknown",
    "course": "unknown",
    "exerciseCourse": "unknown",
    "countryOfOrigin": "(0..1)",
    "creator": "(0..1)",
    "currenciesAccepted": "(0..1)",
    "customer": "unknown",
    "dataset": "unknown",
    "dateCreated": "(0..1)",
    "dateline": "unknown",
    "dateDeleted": "(0..1)",
    "dateModified": "(0..1)",
    "datePosted": "unknown",
    "datePublished": "unknown",
    "dayOfWeek": "(1..*)",
    "deathDate": "unknown",
    "deliveryAddress": "unknown",
    "deliveryLeadTime": "(0..1)",
    "deliveryMethod": "unknown",
    "deliveryStatus": "unknown",
    "department": "unknown",
    "dependencies": "unknown",
    "depth": "(0..1)",
    "description": "(0..1)",
    "device": "unknown",
    "availableOnDevice": "unknown",
    "director": "unknown",
    "directors": "unknown",
    "disambiguatingDescription": "unknown",
    "discount": "unknown",
    "discountCode": "unknown",
    "discountCurrency": "(0..1)",
    "discusses": "unknown",
    "discussionUrl": "unknown",
    "distance": "(0..1)",
    "distribution": "unknown",
    "doorTime": "(0..1)",
    "downloadUrl": "unknown",
    "duns": "(0..1)",
    "duration": "(0..1)",
    "durationOfWarranty": "(0..1)",
    "editor": "unknown",
    "educationalAlignment": "unknown",
    "educationalFramework": "(0..1)",
    "educationalRole": "unknown",
    "educationalUse": "(0..1)",
    "educationRequirements": "unknown",
    "elevation": "(0..1)",
    "eligibleCustomerType": "(0..*)",
    "eligibleDuration": "(0..1)",
    "eligibleQuantity": "(0..1)",
    "eligibleRegion": "(0..*)",
    "ineligibleRegion": "(0..*)",
    "eligibleTransactionVolume": "(0..1)",
    "email": "unknown",
    "embedUrl": "unknown",
    "employee": "unknown",
    "employees": "unknown",
    "employmentType": "unknown",
    "encodesCreativeWork": "(0..1)",
    "encoding": "unknown",
    "encodingFormat": "unknown",
    "encodings": "unknown",
    "endDate": "(0..1)",
    "endorsee": "unknown",
    "endTime": "(0..1)",
    "entertainmentBusiness": "unknown",
    "episode": "unknown",
    "episodeNumber": "unknown",
    "episodes": "unknown",
    "equal": "(0..*)",
    "event": "unknown",
    "events": "unknown",
    "eventStatus": "unknown",
    "exifData": "unknown",
    "expectedArrivalFrom": "(0..1)",
    "expectedArrivalUntil": "(0..1)",
    "experienceRequirements": "unknown",
    "expires": "unknown",
    "familyName": "unknown",
    "faxNumber": "(0..1)",
    "featureList": "unknown",
    "fileFormat": "unknown",
    "fileSize": "unknown",
    "followee": "unknown",
    "follows": "(0..*)",
    "founder": "unknown",
    "founders": "unknown",
    "dissolutionDate": "(0..1)",
    "foundingDate": "(0..1)",
    "free": "unknown",
    "isAccessibleForFree": "(0..1)",
    "publicAccess": "unknown",
    "fromLocation": "unknown",
    "gender": "unknown",
    "genre": "unknown",
    "geo": "(0..1)",
    "geographicArea": "(0..1)",
    "givenName": "unknown",
    "globalLocationNumber": "(0..1)",
    "greater": "(0..*)",
    "greaterOrEqual": "(0..*)",
    "gtin12": "(0..1)",
    "gtin13": "(0..*)",
    "gtin14": "(0..*)",
    "gtin8": "(0..*)",
    "hasDeliveryMethod": "unknown",
    "hasPOS": "(0..*)",
    "headline": "unknown",
    "height": "(0..1)",
    "highPrice": "(0..1)",
    "hiringOrganization": "unknown",
    "homeLocation": "unknown",
    "honorificPrefix": "unknown",
    "honorificSuffix": "unknown",
    "hoursAvailable": "(0..1)",
    "illustrator": "(0..1)",
    "image": "unknown",
    "inAlbum": "(0..1)",
    "incentives": "unknown",
    "incentiveCompensation": "unknown",
    "includesObject": "(0..*)",
    "industry": "(0..1)",
    "inLanguage": "(0..1)",
    "inPlaylist": "(0..1)",
    "installUrl": "unknown",
    "instrument": "(0..1)",
    "interactionCount": "unknown",
    "interactivityType": "(0..1)",
    "inventoryLevel": "(0..1)",
    "isAccessoryOrSparePartFor": "(0..*)",
    "isBasedOnUrl": "(0..1)",
    "isBasedOn": "(0..1)",
    "isbn": "(0..1)",
    "isConsumableFor": "(0..*)",
    "isFamilyFriendly": "(0..1)",
    "isGift": "(0..1)",
    "isicV4": "(0..*)",
    "isPartOf": "(0..1)",
    "isRelatedTo": "(0..1)",
    "isSimilarTo": "(0..*)",
    "issuedThrough": "(0..1)",
    "isVariantOf": "(0..1)",
    "itemCondition": "unknown",
    "numberOfItems": "(0..1)",
    "itemListOrder": "unknown",
    "itemOffered": "(0..1)",
    "itemReviewed": "(0..1)",
    "itemShipped": "(0..*)",
    "jobLocation": "unknown",
    "jobTitle": "(0..1)",
    "keywords": "unknown",
    "knows": "(0..1)",
    "landlord": "unknown",
    "language": "unknown",
    "lastReviewed": "unknown",
    "latitude": "(0..1)",
    "license": "unknown",
    "learningResourceType": "(0..1)",
    "legalName": "(0..1)",
    "lender": "unknown",
    "lesser": "(0..*)",
    "lesserOrEqual": "(0..*)",
    "line": "unknown",
    "location": "(0..1)",
    "logo": "unknown",
    "longitude": "(0..1)",
    "loser": "unknown",
    "lowPrice": "(0..1)",
    "mainContentOfPage": "unknown",
    "mainEntity": "unknown",
    "mainEntityOfPage": "unknown",
    "makesOffer": "(0..*)",
    "offeredBy": "unknown",
    "hasMap": "unknown",
    "map": "unknown",
    "maps": "unknown",
    "maximumAttendeeCapacity": "(0..1)",
    "remainingAttendeeCapacity": "(0..1)",
    "maxPrice": "(1..1)",
    "maxValue": "(0..1)",
    "member": "unknown",
    "memberOf": "unknown",
    "members": "unknown",
    "memoryRequirements": "unknown",
    "mentions": "unknown",
    "hasMenu": "unknown",
    "menu": "unknown",
    "merchant": "unknown",
    "minPrice": "(1..1)",
    "minValue": "(0..1)",
    "model": "(0..1)",
    "mpn": "(0..*)",
    "manufacturer": "(0..1)",
    "musicBy": "(0..1)",
    "musicGroupMember": "unknown",
    "naics": "(0..*)",
    "name": "(0..1)",
    "nationality": "unknown",
    "netWorth": "(0..1)",
    "nonEqual": "(0..*)",
    "numberOfEmployees": "(0..1)",
    "numberOfEpisodes": "(0..1)",
    "numberOfPages": "(0..1)",
    "numberOfSeasons": "(0..1)",
    "numTracks": "(0..1)",
    "object": "(0..1)",
    "occupationalCategory": "unknown",
    "offerCount": "(0..1)",
    "offers": "(0..*)",
    "openingHours": "(0..1)",
    "openingHoursSpecification": "(0..*)",
    "specialOpeningHoursSpecification": "(0..1)",
    "opens": "(1..1)",
    "operatingSystem": "unknown",
    "opponent": "unknown",
    "option": "unknown",
    "actionOption": "unknown",
    "orderDate": "unknown",
    "orderedItem": "(0..1)",
    "orderNumber": "(0..1)",
    "orderStatus": "(0..1)",
    "originAddress": "unknown",
    "ownedFrom": "(0..1)",
    "ownedThrough": "(0..1)",
    "owns": "(0..*)",
    "parent": "unknown",
    "parents": "unknown",
    "parentService": "unknown",
    "participant": "unknown",
    "partOfEpisode": "(0..1)",
    "partOfInvoice": "(0..1)",
    "partOfOrder": "(0..1)",
    "partOfSeason": "(0..1)",
    "partOfSeries": "(0..1)",
    "partOfTVSeries": "(0..1)",
    "paymentAccepted": "unknown",
    "paymentDue": "(0..1)",
    "paymentMethod": "(0..1)",
    "paymentMethodId": "unknown",
    "paymentUrl": "(0..1)",
    "performer": "unknown",
    "performerIn": "unknown",
    "performers": "(0..1)",
    "permissions": "(0..*)",
    "permitAudience": "(0..1)",
    "photo": "unknown",
    "photos": "unknown",
    "playerType": "unknown",
    "polygon": "unknown",
    "position": "(0..1)",
    "postalCode": "(0..1)",
    "postOfficeBoxNumber": "(0..1)",
    "predecessorOf": "(0..*)",
    "previousStartDate": "unknown",
    "price": "(0..1)",
    "priceRange": "(0..1)",
    "priceSpecification": "(0..*)",
    "priceType": "(0..1)",
    "priceValidUntil": "(0..1)",
    "primaryImageOfPage": "unknown",
    "printColumn": "(0..1)",
    "printEdition": "(0..1)",
    "printPage": "unknown",
    "printSection": "unknown",
    "processingTime": "unknown",
    "processorRequirements": "unknown",
    "producer": "(0..1)",
    "produces": "(0..1)",
    "serviceOutput": "(0..1)",
    "productID": "(0..1)",
    "productionCompany": "(0..1)",
    "productSupported": "(0..1)",
    "proficiencyLevel": "unknown",
    "programmingLanguage": "(0..1)",
    "programmingModel": "unknown",
    "providesService": "(0..1)",
    "publication": "unknown",
    "publishedOn": "unknown",
    "publisher": "(0..1)",
    "publishingPrinciples": "(0..1)",
    "qualifications": "unknown",
    "query": "unknown",
    "question": "unknown",
    "ratingCount": "(0..1)",
    "ratingValue": "(0..1)",
    "realEstateAgent": "unknown",
    "recipient": "unknown",
    "recordedAt": "(0..1)",
    "recordedIn": "(0..1)",
    "relatedLink": "unknown",
    "relatedTo": "(0..1)",
    "releaseDate": "(0..1)",
    "releaseNotes": "unknown",
    "replacee": "unknown",
    "replacer": "unknown",
    "replyToUrl": "(0..1)",
    "representativeOfPage": "unknown",
    "requiredGender": "unknown",
    "requiredMaxAge": "unknown",
    "requiredMinAge": "unknown",
    "requirements": "unknown",
    "softwareRequirements": "unknown",
    "requiresSubscription": "unknown",
    "responsibilities": "unknown",
    "result": "(0..1)",
    "resultComment": "unknown",
    "resultReview": "unknown",
    "review": "unknown",
    "reviewBody": "(0..1)",
    "reviewCount": "(0..1)",
    "reviewedBy": "unknown",
    "reviewRating": "(0..1)",
    "reviews": "unknown",
    "runtime": "unknown",
    "runtimePlatform": "unknown",
    "salaryCurrency": "(0..1)",
    "sameAs": "unknown",
    "sampleType": "unknown",
    "codeSampleType": "unknown",
    "scheduledTime": "(0..1)",
    "screenCount": "(0..1)",
    "videoFormat": "(0..1)",
    "screenshot": "unknown",
    "season": "unknown",
    "containsSeason": "unknown",
    "seasonNumber": "unknown",
    "seasons": "unknown",
    "seeks": "(0..*)",
    "seller": "unknown",
    "sender": "unknown",
    "serialNumber": "(0..*)",
    "servesCuisine": "(0..1)",
    "serviceArea": "(0..1)",
    "serviceAudience": "(0..1)",
    "serviceLocation": "(0..1)",
    "serviceOperator": "(0..1)",
    "servicePhone": "(0..1)",
    "servicePostalAddress": "(0..1)",
    "serviceSmsNumber": "(0..1)",
    "serviceType": "(0..1)",
    "serviceUrl": "(0..1)",
    "sibling": "unknown",
    "siblings": "unknown",
    "significantLink": "unknown",
    "significantLinks": "(0..1)",
    "skills": "unknown",
    "sku": "(0..*)",
    "softwareVersion": "unknown",
    "sourceOrganization": "(0..1)",
    "spatial": "(0..1)",
    "spatialCoverage": "(0..*)",
    "specialCommitments": "unknown",
    "specialty": "unknown",
    "sponsor": "unknown",
    "funder": "unknown",
    "sportsActivityLocation": "unknown",
    "sportsEvent": "unknown",
    "sportsTeam": "unknown",
    "spouse": "(0..1)",
    "startDate": "(0..1)",
    "startTime": "(0..1)",
    "storageRequirements": "unknown",
    "streetAddress": "(0..1)",
    "subEvent": "unknown",
    "subEvents": "unknown",
    "subOrganization": "unknown",
    "subtitleLanguage": "unknown",
    "successorOf": "(0..*)",
    "suggestedGender": "(0..1)",
    "suggestedMaxAge": "unknown",
    "suggestedMinAge": "unknown",
    "suitableForDiet": "unknown",
    "superEvent": "unknown",
    "supportingData": "unknown",
    "targetDescription": "(0..1)",
    "targetName": "(0..1)",
    "targetPlatform": "unknown",
    "targetProduct": "unknown",
    "targetUrl": "(0..1)",
    "taxID": "(0..1)",
    "telephone": "(0..1)",
    "temporalCoverage": "(0..1)",
    "temporal": "(0..1)",
    "datasetTimeInterval": "(0..1)",
    "text": "(0..1)",
    "thumbnail": "unknown",
    "thumbnailUrl": "unknown",
    "tickerSymbol": "(0..1)",
    "timeRequired": "unknown",
    "title": "(0..1)",
    "toLocation": "unknown",
    "toRecipient": "unknown",
    "trackingNumber": "unknown",
    "trackingUrl": "unknown",
    "tracks": "unknown",
    "trailer": "(0..1)",
    "transcript": "unknown",
    "typeOfGood": "(1..1)",
    "typicalAgeRange": "(0..1)",
    "unitCode": "(1..1)",
    "uploadDate": "unknown",
    "url": "unknown",
    "validFor": "(0..1)",
    "validFrom": "(0..1)",
    "validIn": "(0..1)",
    "validThrough": "(0..1)",
    "validUntil": "(0..1)",
    "value": "(0..1)",
    "valueAddedTaxIncluded": "(0..1)",
    "valueReference": "(0..*)",
    "vatID": "(0..1)",
    "vendor": "unknown",
    "version": "(0..1)",
    "video": "unknown",
    "videoFrameSize": "(0..1)",
    "videoQuality": "(0..1)",
    "warranty": "(0..*)",
    "paymentDueDate": "(0..1)",
    "warrantyPromise": "(0..*)",
    "warrantyScope": "(0..1)",
    "weight": "(0..1)",
    "width": "(0..1)",
    "winner": "unknown",
    "wordCount": "(0..1)",
    "workHours": "(0..1)",
    "workLocation": "unknown",
    "worksFor": "unknown",
    "worstRating": "(0..1)",
    "yearlyRevenue": "(0..1)",
    "yearsInOperation": "(0..1)",
    "reservationId": "unknown",
    "reservationStatus": "(0..1)",
    "reservationFor": "(0..1)",
    "underName": "(0..1)",
    "provider": "(0..1)",
    "providerMobility": "unknown",
    "bookingAgent": "unknown",
    "bookingTime": "(0..1)",
    "modifiedTime": "(0..1)",
    "programMembershipUsed": "unknown",
    "reservedTicket": "unknown",
    "totalPrice": "(0..1)",
    "priceCurrency": "(1..1)",
    "membershipNumber": "unknown",
    "programName": "(0..1)",
    "hostingOrganization": "(0..1)",
    "issuedBy": "(0..1)",
    "dateIssued": "(0..1)",
    "ticketedSeat": "(0..1)",
    "ticketNumber": "(0..1)",
    "ticketToken": "unknown",
    "seatNumber": "(0..1)",
    "seatRow": "(0..1)",
    "seatSection": "(0..1)",
    "seatingType": "(0..1)",
    "subReservation": "(0..1)",
    "boardingGroup": "(0..1)",
    "passengerSequenceNumber": "(0..1)",
    "securityScreening": "(0..1)",
    "passengerPriorityStatus": "(0..1)",
    "flightNumber": "(0..1)",
    "departureTime": "(0..1)",
    "arrivalTime": "(0..1)",
    "departureAirport": "(0..1)",
    "arrivalAirport": "(0..1)",
    "departureGate": "unknown",
    "arrivalGate": "unknown",
    "boardingPolicy": "(0..1)",
    "departureTerminal": "unknown",
    "arrivalTerminal": "unknown",
    "aircraft": "(0..1)",
    "mealService": "unknown",
    "estimatedFlightDuration": "(0..1)",
    "flightDistance": "(0..1)",
    "webCheckinTime": "(0..1)",
    "iataCode": "unknown",
    "icaoCode": "unknown",
    "partySize": "unknown",
    "trainNumber": "(0..1)",
    "trainName": "(0..1)",
    "departureStation": "(0..1)",
    "arrivalStation": "(0..1)",
    "departurePlatform": "(0..1)",
    "arrivalPlatform": "(0..1)",
    "busNumber": "(0..1)",
    "busName": "(0..1)",
    "departureBusStop": "(0..1)",
    "arrivalBusStop": "(0..1)",
    "pickupLocation": "unknown",
    "dropoffLocation": "unknown",
    "pickupTime": "unknown",
    "dropoffTime": "unknown",
    "checkinTime": "(0..1)",
    "checkoutTime": "(0..1)",
    "lodgingUnitType": "unknown",
    "lodgingUnitDescription": "unknown",
    "numAdults": "(0..1)",
    "numChildren": "(0..1)",
    "upvoteCount": "(0..1)",
    "downvoteCount": "(0..1)",
    "answerCount": "(0..1)",
    "commentCount": "(0..1)",
    "acceptedAnswer": "(0..1)",
    "parentItem": "(0..1)",
    "suggestedAnswer": "unknown",
    "actionStatus": "unknown",
    "error": "unknown",
    "potentialAction": "unknown",
    "actionPlatform": "(0..*)",
    "target": "unknown",
    "httpMethod": "unknown",
    "encodingType": "(0..*)",
    "contentType": "(0..*)",
    "application": "unknown",
    "actionApplication": "unknown",
    "urlTemplate": "unknown",
    "valueName": "unknown",
    "valueRequired": "unknown",
    "defaultValue": "(0..1)",
    "readonlyValue": "unknown",
    "multipleValues": "unknown",
    "valueMinLength": "unknown",
    "valueMaxLength": "unknown",
    "valuePattern": "unknown",
    "workPresented": "(0..1)",
    "stepValue": "(0..1)",
    "workPerformed": "unknown",
    "workFeatured": "unknown",
    "characterName": "(0..1)",
    "namedPosition": "unknown",
    "roleName": "unknown",
    "hasPart": "unknown",
    "issn": "(0..1)",
    "issueNumber": "(0..1)",
    "pageEnd": "(0..1)",
    "pageStart": "(0..1)",
    "pagination": "unknown",
    "volumeNumber": "unknown",
    "workExample": "unknown",
    "exampleOfWork": "unknown",
    "broker": "unknown",
    "itemListElement": "unknown",
    "item": "unknown",
    "previousItem": "unknown",
    "nextItem": "unknown",
    "numberOfPlayers": "unknown",
    "quest": "(0..1)",
    "gameItem": "unknown",
    "character": "unknown",
    "characterAttribute": "unknown",
    "playMode": "unknown",
    "translator": "unknown",
    "softwareAddOn": "unknown",
    "cheatCode": "unknown",
    "softwareHelp": "unknown",
    "gameTip": "unknown",
    "gamePlatform": "(0..1)",
    "serverStatus": "unknown",
    "playersOnline": "unknown",
    "game": "unknown",
    "gameServer": "(0..1)",
    "gameLocation": "unknown",
    "albumProductionType": "unknown",
    "albumReleaseType": "(0..1)",
    "albumRelease": "unknown",
    "track": "unknown",
    "musicArrangement": "unknown",
    "composer": "(0..1)",
    "firstPerformance": "(0..1)",
    "includedComposition": "unknown",
    "iswcCode": "(0..1)",
    "lyricist": "(0..1)",
    "musicCompositionForm": "(0..1)",
    "musicalKey": "(0..1)",
    "recordedAs": "unknown",
    "isrcCode": "(0..1)",
    "recordingOf": "(0..1)",
    "catalogNumber": "(0..1)",
    "creditedTo": "(0..1)",
    "musicReleaseFormat": "unknown",
    "recordLabel": "(0..1)",
    "releaseOf": "(0..1)",
    "regionsAllowed": "(0..1)",
    "releasedEvent": "(0..1)",
    "foundingLocation": "(0..1)",
    "birthPlace": "(0..1)",
    "deathPlace": "(0..1)",
    "sport": "unknown",
    "coach": "unknown",
    "athlete": "unknown",
    "numberedPosition": "unknown",
    "homeTeam": "(0..1)",
    "awayTeam": "(0..1)",
    "competitor": "unknown",
    "amount": "(0..1)",
    "currency": "(0..1)",
    "artform": "unknown",
    "material": "unknown",
    "artMedium": "(0..1)",
    "surface": "unknown",
    "artworkSurface": "(0..1)",
    "artEdition": "(0..1)",
    "totalPaymentDue": "(0..1)",
    "minimumPaymentDue": "(0..1)",
    "accountId": "(0..1)",
    "scheduledPaymentDate": "(0..1)",
    "billingPeriod": "(0..1)",
    "paymentStatus": "(0..1)",
    "referencesOrder": "(0..*)",
    "additionalProperty": "unknown",
    "unitText": "unknown",
    "propertyID": "unknown",
    "broadcastAffiliateOf": "(0..*)",
    "broadcastDisplayName": "(0..1)",
    "broadcastOfEvent": "(0..1)",
    "broadcastTimezone": "(0..1)",
    "isLiveBroadcast": "(0..1)",
    "broadcastChannelId": "(0..1)",
    "inBroadcastLineup": "(0..1)",
    "broadcastServiceTier": "(0..1)",
    "providesBroadcastService": "(0..1)",
    "numberOfDoors": "(0..*)",
    "numberOfAirbags": "(0..1)",
    "numberOfAxles": "(0..*)",
    "vehicleEngine": "unknown",
    "fuelConsumption": "(0..1)",
    "fuelEfficiency": "(0..1)",
    "numberOfForwardGears": "(0..*)",
    "vehicleIdentificationNumber": "(0..1)",
    "cargoVolume": "(0..*)",
    "vehicleConfiguration": "unknown",
    "knownVehicleDamages": "unknown",
    "dateVehicleFirstRegistered": "(0..1)",
    "driveWheelConfiguration": "(0..1)",
    "fuelType": "(0..1)",
    "vehicleInteriorColor": "(0..1)",
    "vehicleInteriorType": "(0..1)",
    "mileageFromOdometer": "(0..*)",
    "vehicleModelDate": "(0..1)",
    "numberOfPreviousOwners": "(0..*)",
    "productionDate": "(0..1)",
    "purchaseDate": "(0..1)",
    "vehicleSeatingCapacity": "(0..*)",
    "vehicleTransmission": "(0..*)",
    "steeringPosition": "(0..1)",
    "vehicleSpecialUsage": "unknown",
    "interactionService": "(0..1)",
    "interactionStatistic": "(0..1)",
    "interactionType": "(0..1)",
    "userInteractionCount": "(0..1)",
    "sharedContent": "unknown",
    "coverageStartTime": "(0..1)",
    "coverageEndTime": "(0..1)",
    "liveBlogUpdate": "unknown",
    "reportNumber": "(0..1)",
    "lyrics": "(0..1)",
    "calories": "(0..1)",
    "carbohydrateContent": "(0..1)",
    "cholesterolContent": "(0..1)",
    "fiberContent": "(0..1)",
    "proteinContent": "(0..1)",
    "saturatedFatContent": "(0..1)",
    "servingSize": "(0..1)",
    "sodiumContent": "(0..1)",
    "sugarContent": "(0..1)",
    "cookTime": "(0..1)",
    "cookingMethod": "(0..1)",
    "fatContent": "(0..1)",
    "foodEstablishment": "unknown",
    "foodEvent": "unknown",
    "nutrition": "unknown",
    "recipeCategory": "(0..1)",
    "recipeCuisine": "(0..1)",
    "ingredients": "unknown",
    "recipeIngredient": "unknown",
    "recipeInstructions": "unknown",
    "recipeYield": "(0..1)",
    "recipe": "unknown",
    "transFatContent": "(0..1)",
    "unsaturatedFatContent": "(0..1)",
    "dataFeedElement": "unknown",
    "referenceQuantity": "(0..1)",
    "leiCode": "unknown",
    "annualPercentageRate": "(0..1)",
    "feesAndCommissionsSpecification": "unknown",
    "interestRate": "(0..1)",
    "loanTerm": "(0..1)",
    "requiredCollateral": "unknown",
    "dateRead": "(0..1)",
    "dateReceived": "(0..1)",
    "dateSent": "(0..1)",
    "messageAttachment": "unknown",
    "priceComponent": "unknown",
    "hasDigitalDocumentPermission": "unknown",
    "grantee": "(0..1)",
    "permissionType": "(0..1)",
    "amenityFeature": "unknown",
    "typeOfBed": "(0..1)",
    "bed": "(0..1)",
    "numberOfRooms": "(0..*)",
    "floorSize": "(0..*)",
    "occupancy": "(0..*)",
    "permittedUsage": "unknown",
    "petsAllowed": "unknown",
    "smokingAllowed": "unknown",
    "numberOfBeds": "(0..1)",
    "starRating": "unknown",
    "estimatedCost": "(0..1)",
    "performTime": "(0..1)",
    "prepTime": "(0..1)",
    "supply": "unknown",
    "steps": "(0..1)",
    "tool": "unknown",
    "totalTime": "(0..1)",
    "yield": "(0..1)",
    "afterMedia": "unknown",
    "beforeMedia": "unknown",
    "duringMedia": "unknown",
    "requiredQuantity": "(0..*)",
    "courseCode": "(0..1)",
    "coursePrerequisites": "unknown",
    "hasCourseInstance": "unknown",
    "courseMode": "(0..1)",
    "instructor": "unknown",
    "identifier": "(0..1)",
    "claimReviewed": "unknown",
    "hasMenuItem": "unknown",
    "hasMenuSection": "unknown",
    "accessMode": "(0..1)",
    "accessModeSufficient": "unknown",
    "accessibilitySummary": "unknown"
}

JSON
, $commandTester->getDisplay());
    }
}
